package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.models.QuizHistory;
import com.ElyStudio.leGaou.utilities.Constants;
import com.squareup.picasso.Picasso;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class QuizHistoryAdapter extends RecyclerView.Adapter<QuizHistoryAdapter.QuizHistoryViewHolder> {

    private final List<QuizHistory> quizHistoryList;
    private final Context context;

    public QuizHistoryAdapter(List<QuizHistory> quizHistoryList, Context context) {
        this.quizHistoryList = quizHistoryList;
        this.context = context;
    }

    @NonNull
    @Override
    public QuizHistoryAdapter.QuizHistoryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new QuizHistoryViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.quiz_history_layout,parent,false));
    }

    @Override
    public void onBindViewHolder(@NonNull QuizHistoryAdapter.QuizHistoryViewHolder holder, int position) {
        QuizHistory quizHistory = quizHistoryList.get(position);

        int bgColor,textColor;

        if(quizHistory.getColor() == 1)
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_1);
            textColor = context.getResources().getColor(R.color.quiz_color_text_1);
        }
        else if(quizHistory.getColor() == 2)
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_2);
            textColor = context.getResources().getColor(R.color.quiz_color_text_2);
        }
        else if(quizHistory.getColor() == 3)
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_3);
            textColor = context.getResources().getColor(R.color.quiz_color_text_3);
        }
        else if(quizHistory.getColor() == 4)
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_4);
            textColor = context.getResources().getColor(R.color.quiz_color_text_4);
        }
        else if(quizHistory.getColor() == 5)
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_5);
            textColor = context.getResources().getColor(R.color.quiz_color_text_5);
        }
        else if(quizHistory.getColor() == 6)
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_6);
            textColor = context.getResources().getColor(R.color.quiz_color_text_6);
        }
        else if(quizHistory.getColor() == 7)
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_7);
            textColor = context.getResources().getColor(R.color.quiz_color_text_7);
        }
        else if(quizHistory.getColor() == 8)
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_8);
            textColor = context.getResources().getColor(R.color.quiz_color_text_8);
        }
        else
        {
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_default);
            textColor = context.getResources().getColor(R.color.primary_text_color);
        }

        holder.quizName.setText(quizHistory.getQuizName());
        holder.quizIconBg.setBackgroundColor(bgColor);
        if(quizHistory.getEntryFee() == 0)
        {
            holder.quizEntryFee.setText(context.getResources().getString(R.string.free));
        }
        else
        {
            holder.quizEntryFee.setText(String.valueOf(quizHistory.getEntryFee()));
        }
        holder.quizPrize.setText(String.valueOf(quizHistory.getPrize()));
        holder.questionAttempted.setText(String.valueOf(quizHistory.getQuestionAttempted()));
        holder.correctAnswers.setText(String.valueOf(quizHistory.getCorrectAnswers()));
        holder.wrongAnswers.setText(String.valueOf(quizHistory.getWrongAnswers()));
        holder.quizName.setTextColor(textColor);

        if(quizHistory.getIcon().trim().isEmpty())
        {
            holder.quizIcon.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.image_placeholder));
        }
        else
        {
            Picasso.get().load(Constants.ADMIN_PANEL_URL +quizHistory.getIcon()).into(holder.quizIcon);
        }
        Date date = new Date(Long.parseLong(quizHistory.getDate()) * 1000);
        String playingTime = new SimpleDateFormat("d MMM yyyy, hh:mm aaa", Locale.getDefault()).format(date);
        holder.playingDate.setText(playingTime);

    }

    @Override
    public int getItemCount() {
        return quizHistoryList.size();
    }

    public static class QuizHistoryViewHolder extends RecyclerView.ViewHolder {
        ImageView quizIcon;
        FrameLayout quizIconBg;
        TextView quizName,quizEntryFee,quizPrize,questionAttempted,correctAnswers,wrongAnswers,playingDate;
        public QuizHistoryViewHolder(@NonNull View itemView) {
            super(itemView);

            quizIcon = itemView.findViewById(R.id.quizHistoryIcon);

            quizName = itemView.findViewById(R.id.quizHistoryName);
            quizIconBg = itemView.findViewById(R.id.quizIconBg);
            quizEntryFee = itemView.findViewById(R.id.quizHistoryEntryFee);
            quizPrize = itemView.findViewById(R.id.quizHistoryPrize);
            questionAttempted = itemView.findViewById(R.id.quizHistoryQuestionAttempted);
            correctAnswers = itemView.findViewById(R.id.quizHistoryCorrectAnswers);
            wrongAnswers = itemView.findViewById(R.id.quizHistoryWrongAnswers);
            playingDate = itemView.findViewById(R.id.quizHistoryDate);


        }
    }
}
